// stringtools.c

#include <Carbon.h>
#include "stringtools.h"

void ConvertPString( const unsigned char *pS, char *cS )
{
	short size = *pS++;
	
	while( size-- ) *cS++ = *pS++;
	*cS = 0;
}

void ConvertCString( const char *cS, unsigned char *pS )
{
	unsigned char *pP = ++pS;
	
	while( *cS ) *pP++ = *cS++;
	*(pS-1) = pP - pS;
}

Boolean TrimPString( Str255 trim )
{
	short in = 0, out = 0;
	
	while( ++in <= trim[0] )
	{
		if( trim[in] >= 32 && trim[in] <= 127 ) // printable ASCII
		{
			trim[++out] = trim[in];
		}
	}
	in--;
	
	trim[0] = out;
	return out != in;
}

void UppercasePString( Str255 ucase )
{
	short in = 0;
	
	while( ++in <= ucase[0] )
	{
		if( ucase[in] >= 'a' && ucase[in] <= 'z' )
		{
			ucase[in] -= 'a'-'A';
		}
	}
}

StringPtr CopyPString(StringPtr str1, StringPtr str2)
{
	unsigned char	*cp = str1;
	unsigned		len = *(unsigned char *)str2;

	do *cp++ = *str2++;
	while( len-- );
	
	return str1;
}

StringPtr ConcatPString(StringPtr str1, StringPtr str2)
{
	unsigned char	*cp = str1;
	unsigned		len1 = *(unsigned char *)str1,
					len2 = *(unsigned char *)str2;
	if ((len1 + len2) >= 255) return 0;
	
	cp += len1 + 1;						// skip to end of str1
	*(unsigned char *)str1 += len2;		// adjust length byte
	++str2;								// don't copy "str2" length byte
	while( len2-- ) *cp++ = *str2++;
	
	return str1;
}

#define tolower(x) ( (((x)>='A') && ((x)<='Z'))? ((x)-'A'+'a'): (x) )

int	stricmp(const char *s1, const char *s2 )
{
	while( *s1 && *s2 ) 
	{
		if( tolower(*s1) - tolower(*s2) ) return tolower(*s1) - tolower(*s2);
		s1++; s2++;
	}
	
	return tolower(*s1) - tolower(*s2);
}
